/*! \file 
**********************************************************************************
*Title:                         Discretix OMA DRM v2 Toolkit source file
*
* Filename:                     ODRM_TLK_ATP_data.h
*
* Project, Target, subsystem:   Toolkit, OMA DRM
* 
* Created:                      03.12.2007
*
* \Author                       Sagitb
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

#ifndef _ODRM_SEC_RO_HANDLING_DATA_H_
#define _ODRM_SEC_RO_HANDLING_DATA_H_

#include "DX_VOS_BaseTypes.h"
#include "ODRM_TLK_ATP_Defines.h"
#include "ODRM_TLK_ATP_UTIL.h"

#define ODRMTLK_ATP_MAX_SIZE_KEY_RING_BUF       8000
#define OCSP_RESP_SIZE 1135
#define RI_CERT_SIZE   696
#define CA_CERT_SIZE   844
#define NONCE_SIZE     20 


#define MODULUS_SIZE  ODRMTLK_TST_RSA_1024_KEY_SIZE_IN_BYTES
#define PRIV_EXP_SIZE ODRMTLK_TST_RSA_1024_KEY_SIZE_IN_BYTES
#define PUB_EXP_SIZE 3
#define TEMP_BUFF_LEN 16
#define GROUP_ID_KEY_SIZE 7

extern DxByte_t* TST_RiIDKey;
extern DxByte_t* TST_InvRiIDKey;
extern DxUint8_t RegistrationOCSPResp[OCSP_RESP_SIZE];
extern DxUint8_t RICert[RI_CERT_SIZE];
extern DxUint8_t CACert[CA_CERT_SIZE];
extern DxUint8_t RegistrationRequestClientNonce[NONCE_SIZE];
extern DxUint8_t PrivModulus[MODULUS_SIZE];
extern DxUint8_t PrivExponent[PRIV_EXP_SIZE];
extern DxUint8_t PubExponent[PUB_EXP_SIZE];
extern DxUint8_t InvalidCACert[CA_CERT_SIZE];
extern DxUint8_t InvalidRICert[RI_CERT_SIZE];
extern DxUint8_t InvalidDeviceNonce[NONCE_SIZE];

extern DxUint8_t SecretDomainKey[16];
extern DxUint8_t InvSecretDomainKey[16];

extern const DxChar_t* InvalidKeyDomainXML;
extern const DxChar_t* DomainXML;
extern const DxChar_t* DomainRoXml;
extern const char* ServiceTimeString;
extern const DxChar_t* DomainRightsXmlStr;
extern const DxChar_t* RightsXmlStr;
extern const DxChar_t* RoXml;
extern const DxChar_t* ChildRightsXmlStr;

extern const DxChar_t* ParentRightsXmlStr;

extern const DxChar_t* InvParentKeyRightsXmlStr;
extern const DxChar_t* InvParentKeyRoXml;
extern const DxChar_t* InvParentIntegrityRightsXmlStr;
extern const DxChar_t* InvParentIntegrityRoXml;
extern const DxChar_t* ExpiredRightsXmlStr;
extern const DxChar_t* ExpiredRoXml;
extern const DxChar_t* InvalidKeyRightsXmlStr;
extern const DxChar_t* InvalidKeyRoXml;
extern const DxChar_t* InvIntegrityRightsXmlStr;
extern const DxChar_t* InvIntegrityRoXml;
extern const DxChar_t* TwoRestrRightsXmlStr;
extern const DxChar_t* TwoRestrRoXml;
extern const DxChar_t* GIDRightsXmlStr;


extern CRYS_AES_IvCounter_t IvCounter;

extern DxUint8_t TST_PlainBuff[TEMP_BUFF_LEN];
extern DxUint8_t TST_EncryptBuff[TEMP_BUFF_LEN];

extern DxUint8_t TST_PlainBuffCid6093[TEMP_BUFF_LEN];
extern DxUint8_t TST_EncryptBuffCid6093[TEMP_BUFF_LEN];

extern DxUint8_t TST_PlainBuffCid61331[TEMP_BUFF_LEN];
extern DxUint8_t TST_EncryptBuffCid61331[TEMP_BUFF_LEN];

extern DxUint8_t TST_PlainBuffCid61211[TEMP_BUFF_LEN];
extern DxUint8_t TST_EncryptBuffCid61211[TEMP_BUFF_LEN];

extern DxUint8_t TST_PlainBuffCid6051[TEMP_BUFF_LEN];
extern DxUint8_t TST_EncryptBuffCid6051[TEMP_BUFF_LEN];

extern DxUint8_t  TST_DataoutBuff[TEMP_BUFF_LEN];
extern DxUint8_t  TST_gKeyRingDomain[ODRMTLK_ATP_MAX_SIZE_KEY_RING_BUF];
extern DxUint8_t  TST_gKeyRingDevice[ODRMTLK_ATP_MAX_SIZE_KEY_RING_BUF];
extern DxUint8_t  TST_gKeyRingKmacKrec[ODRMTLK_ATP_MAX_SIZE_KEY_RING_BUF];
extern DxUint8_t  TST_gParentKeyRingKmacKrec[ODRMTLK_ATP_MAX_SIZE_KEY_RING_BUF];

extern DxUint8_t TST_gGroupIDKey[48];
extern DxUint8_t TST_gInvalidGroupIDKey[48];




extern DxUint32_t RO_TST_gWorkspaceSizeInBytes;
extern DxUint8_t   RO_TST_gWorkspace[25000];
#endif
